﻿/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

appModule.service('Utils', function () {
    var self = this;

    self.mainCtrl = null;
    self.overlayCtrl = null;

    self.addClass = function(ele, cls) {
        if (!$(ele).hasClass(cls))
            ele.className += " " + cls;
    }

    self.removeClass = function (ele, cls) {
        if ($(ele).hasClass(cls)) {
            var reg = new RegExp('(\\s|^)' + cls + '(\\s|$)');
            ele.className = ele.className.replace(reg, ' ');
        }
    }

    self.titleCase = function (str) {
        return str.replace(/\w\S*/g, function (txt)
        {
            return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
        });
    }

    /* Localization data and functions */
    self.localizationStringMap = {}; //This is global map to store all localization strings.
    self.locale = "en_US";

    self.setLocale = function (inLocale, inLocalizationStringMap) {
        if (inLocale)
            self.locale = inLocale;

        if (inLocalizationStringMap) {
            self.localizationStringMap = inLocalizationStringMap;
            self.mainCtrl.showContainer();
        } else {
            $.getJSON("Dictionary/" + self.locale + ".json", function (localeData) {
                self.localizationStringMap = localeData;
                self.mainCtrl.showContainer();
            })
            .fail(function () {
                $.getJSON("Dictionary/en_US.json", function (localeData) {
                    self.localizationStringMap = localeData;
                    self.mainCtrl.showContainer();
                })
            })
        }
    };
    self.getLocalizedString = function (id, param1, param2) {
        var retVal;
        try {
            retVal = self.localizationStringMap[id].message;
        } catch (e) {
            retVal = "undefined";
        }

        if (param1)
            retVal = retVal.replace('{0}', param1);
        if (param2)
            retVal = retVal.replace('{1}', param2);

        return retVal;
    };

    self.setLocalizedTextOnId = function (elementId, localizationId) {
        self.getElemById(elementId).innerHTML = self.getLocalizedString(localizationId);
        self.getElemById(elementId).title = self.getLocalizedString(localizationId);
    };

    self.getElemById = function (id) {
        return document.getElementById(id);
    };

    self.createIframe = function(iframeName) {
        var iframe = document.createElement('iframe');
        iframe.id = iframeName;
        iframe.width = "100%";
        iframe.height = "100%";
        iframe.style.border = "none";
        iframe.frameBorder = 0;
        iframe.scrolling = "no";
        return iframe;
    }

    //Modern version of Fisher–Yates shuffle Algorithm
    self.randomShuffle = function(list) {
        var currentIndex = list.length, randomIndex;

        //till all elements are shuffled keep repeating
        while (currentIndex != 0) {

            // generate a random number between 1 - currentIndex(no of elements remaining)
            randomIndex = Math.floor(Math.random() * currentIndex);
            currentIndex -= 1;

            // Modern form of FY Algo. Moving the random element to the end of the list
            var temp = list[currentIndex];
            list[currentIndex] = list[randomIndex];
            list[randomIndex] = temp;
        }

        return list;
    }


});